import { createEnv } from "@t3-oss/env-nextjs";
import { z } from "zod";

export const env = createEnv({
  /**
   * Specify your server-side environment variables schema here. This way you can ensure the app
   * isn't built with invalid env vars.
   */
  server: {
    NODE_ENV: z.enum(["development", "test", "production"]).default("development"),
    BACKEND_S3_UPLOAD_PATH: z.string(),
    BACKEND_OTP_FEED_STATUS_URL: z.string(),

    BACKEND_S3_DOWNLOAD_PREVIEW_PATH: z.string(),
    BACKEND_S3_DOWNLOAD_LIVE_PATH: z.string(),
  },

  /**
   * Specify your client-side environment variables schema here. This way you can ensure the app
   * isn't built with invalid env vars. To expose them to the client, prefix them with
   * `NEXT_PUBLIC_`.
   */
  client: {
    NEXT_PUBLIC_ANALYTICS_API_URL: z.string().url()
  },

  /**
   * You can't destruct `process.env` as a regular object in the Next.js edge runtimes (e.g.
   * middlewares) or client-side so we need to destruct manually.
   */
  runtimeEnv: {
    // Server-side env vars
    NODE_ENV: process.env.NODE_ENV,

    BACKEND_S3_UPLOAD_PATH: process.env.BACKEND_S3_UPLOAD_PATH,
    BACKEND_OTP_FEED_STATUS_URL: process.env.BACKEND_OTP_FEED_STATUS_URL,
    BACKEND_S3_DOWNLOAD_PREVIEW_PATH: process.env.BACKEND_S3_DOWNLOAD_PREVIEW_PATH,
    BACKEND_S3_DOWNLOAD_LIVE_PATH: process.env.BACKEND_S3_DOWNLOAD_LIVE_PATH,

    // Client-side env vars
    NEXT_PUBLIC_ANALYTICS_API_URL: process.env.NEXT_PUBLIC_ANALYTICS_API_URL
  },
  /**
   * Run `build` or `dev` with `SKIP_ENV_VALIDATION` to skip env validation. This is especially
   * useful for Docker builds.
   */
  skipValidation: !!process.env.SKIP_ENV_VALIDATION,
  /**
   * Makes it so that empty strings are treated as undefined.
   * `SOME_VAR: z.string()` and `SOME_VAR=''` will throw an error.
   */
  emptyStringAsUndefined: true,
});
